#!/bin/bash
#
# Resolve the location of the installation.
# This includes resolving any symlinks.
PRG=$0
while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
        PRG="$link"
    else
        PRG="`dirname "$PRG"`/$link"
    fi
done

MMFADIR=`dirname "$PRG"`

# absolutize dir
oldpwd=`pwd`
cd "${MMFADIR}"
MMFADIR=`pwd`
cd "${oldpwd}"


APPNAME=memorymap-MMfA
TMP_DIR=`mktemp --directory`
DESKTOP_FILE=$TMP_DIR/$APPNAME.desktop
cat << EOF > $DESKTOP_FILE
[Desktop Entry]
Version=2.2.1
Encoding=UTF-8
Name=Memory-Map
Type=Application
Categories=Navigation
Terminal=false
Exec="$MMFADIR/MMfA"
Icon=$APPNAME.png
EOF

# seems necessary to refresh immediately:
chmod 644 $DESKTOP_FILE

xdg-desktop-menu install $DESKTOP_FILE
xdg-icon-resource install --size  32 "$MMFADIR/icon-32.png"  $APPNAME
xdg-icon-resource install --size  48 "$MMFADIR/icon-48.png"  $APPNAME
xdg-icon-resource install --size  64 "$MMFADIR/icon-64.png"  $APPNAME
xdg-icon-resource install --size 128 "$MMFADIR/icon-128.png" $APPNAME


#rm $DESKTOP_FILE
#rm -R $TMP_DIR

